


class Project_XP < Project

  attr_accessor :maps
  attr_accessor :ev_com
  attr_accessor :dossier_rm       # Dossier RM
  attr_accessor :dossier_dmk        # Dossier DMK

  attr_reader :traiter_map
  attr_reader :traiter_bd
  

  F_MODIF = "modif.dmk-dat"

  include DA_RMXP


  def initialize(dossier_rm, dossier_dmk)

    @dossier_rm = dossier_rm
    @dossier_dmk = dossier_dmk

    @dossier_local = "."


    @dir_rtp = []

    # On ouvre le fichier des modifications
    modif_lire

  end

  #### 4.8 ####



  # RMXP version
  def lister_rm(path=@dossier_rm, absolu=true)
    begin

      map = DA::files_reg(path, R_MAP_RMXP, absolu)
      bd = DA::files_reg(path, R_BD_RMXP, absolu)
      return map+bd

    rescue DAE_No_Dir => e
      #puts e.message
      raise(DMKE_No_Dir_Data.new(path))
    end
  end







  def charger_rm(path)

    # On regarde si c'est une map
    if Project::R_MAP_RMXP.correspond?(path)
      return charger_map_rmxp(path)
    end



    if path.regexp_egal(R_BD_RMXP_CommonEvent,
        R_BD_RMXP_Item,
        R_BD_RMXP_Armor,
        R_BD_RMXP_Actor,
        R_BD_RMXP_State,
        R_BD_RMXP_Animation,
        R_BD_RMXP_Tileset,
        R_BD_RMXP_MapInfo,
        R_BD_RMXP_System,
        R_BD_RMXP_Weapon,
        R_BD_RMXP_Skill,
        R_BD_RMXP_Class,
        R_BD_RMXP_Enemy,
        R_BD_RMXP_Troop
      )
      begin
        list = DA::marshal_read(path)
      rescue DAE_Marshal_Open => e
        raise(DMKE_Map_RMXP_Open.new(path))
      rescue DAE_Marshal_Read => e
        raise(DMKE_Map_RMXP_Read.new(path))
      end

      return BDs.identifier(list, path)

    end
  end





  #############





end